//---------------------------------------------------------------------------
#include <iostream.h>
#include <fstream.h>
#include <conio.h>
#include <io.h>

//---------------------------------------------------------------------------
//stae globalne
const int precision = 2;
const int number_width = 5;
const int name_width = 20;
const int amount_width = 8;
const int unit_width = 8;
const int price_width = 8;
const int value_width = 8;
const int path_len = 100;

//---------------------------------------------------------------------------
class produkt {

  public :
    int number;
    double amount;
    double  price;
    double  value;
    string name;
    string unit;

};
//---------------------------------------------------------------------------
class baza {
  private :
    char *sciezka;
    produkt p;
    ifstream we;
    ofstream wy;
    fstream ww;
  public :
    baza(char *path);
    void wyswietl();
    int wyszukaj(int indeks);
    int wyszukaj(string nazwa);
    void dodaj(produkt &p);

    //ifstream operator << (produkt &p);
    //void operator << (istream &we; produkt &p);
};
//---------------------------------------------------------------------------
baza::baza(char *path) {
  baza::sciezka = path;
}
//---------------------------------------------------------------------------
void baza::wyswietl(int indeks) {

  produkt temp;
  bool pass = 0;
  int stare_flagi = we.flags();

  we.clear();

  we.open(baza::sciezka, ios::in);

  do {
    we.setf(ios::skipws);
    we >> temp.number;

    if (!pass && we.eof()) {
      cout << "baza jest pusta!";
    }

    we >> temp.name;
    we >> temp.amount;
    we >> temp.unit;
    we >> temp.price;
    we >> temp.value;
    pass++;

    if (!we.eof()) {

      cout.precision(precision);
      cout.width(number_width); cout.setf(ios::left);
      cout << temp.number << " ";

      cout.width(name_width);
      cout << temp.name;
      cout << " ";

      cout.width(amount_width); cout.setf(ios::fixed);
      cout << temp.amount << " ";

      cout.width(unit_width); cout.unsetf(ios::fixed);
      cout << temp.unit << " ";

      cout.width(price_width); cout.unsetf(ios::left);cout.setf(ios::fixed);
      cout.precision(precision);
      cout << temp.price << " ";

      cout.width(value_width);
      temp.value = temp.price * temp.amount;
      cout << temp.value << endl;

    }

  } while(!we.eof());

  cout.flags(stare_flagi);

  we.close();

  getch();

}
//---------------------------------------------------------------------------
int wyszukaj(int indeks){
}
//---------------------------------------------------------------------------
int wyszukaj(string nazwa){
}
//---------------------------------------------------------------------------
void baza::dodaj(produkt &p) {

  int stare_flagi = wy.flags(),row=1;
  produkt temp;

  we.clear();
  we.open(baza::sciezka, ios::in);

  do {
    we.setf(ios::skipws);
    we >> temp.number;
    !we.eof()?row++:0;
    we >> temp.name;
    we >> temp.amount;
    we >> temp.unit;
    we >> temp.price;
    we >> temp.value;

  } while(!we.eof());

  we.close();

  wy.clear();
  wy.open(baza::sciezka, ios::out|ios::ate|ios::app);

  wy.precision(precision);
  wy.width(number_width); wy.setf(ios::left);
  wy << row << " ";

  wy.width(name_width);
  wy << p.name << " ";

  wy.width(amount_width); wy.setf(ios::fixed);
  wy << p.amount << " ";

  wy.width(unit_width); wy.unsetf(ios::fixed);
  wy << p.unit << " ";

  wy.width(price_width); wy.unsetf(ios::left);wy.setf(ios::fixed);
  wy.precision(precision);
  wy << p.price << " ";

  wy.width(value_width);
  p.value = p.price * p.amount;
  wy << p.value << endl;

  wy.flags(stare_flagi);
  wy.close();
  wy.clear();

}
//---------------------------------------------------------------------------
//funkcja odpowiadajca za wyswitlanie menu gwnego programu
int menu(char *path) {

  clrscr();
  cout << "BAZA v0.1\nplik z danymi: " << path << "\n\n";
  cout << "  menu:\n";
  cout << "  1 - wyswietl cala baze danych\n";
  cout << "  2 - wyszukaj element\n";
  cout << "  3 - dodaj element\n";
  cout << "  4 - usun element\n";
  cout << "  5 - modyfikuj element\n";
  cout << "  0 - zakoncz\n";

  return getch();
}
//---------------------------------------------------------------------------
//funkcja odpowiadajca za wyszukiwanie w bazie
void wyszukaj(baza *base){

  char cha;

  cout << "podaj kryterium wyszukiwania (Indeks, Nazwa) [I/N]#";
  do {
    cha = tolower(getch());
  }while(cha != 'i' && cha != 'n');

  if (cha == 'i') {
    int indeks;
    cout << "\npodaj indeks szukanego elementu: ";
    cin >> indeks;

  }
  else {
    string nazwa;
    cout << "\npodaj nazwe szukanego elementu: ";
    cin >> nazwa;
  }

}
//---------------------------------------------------------------------------
//funkcja odpowiadajca za dodawanie elementu do bazy
void dodaj(baza *base){

    produkt temp;


//    cout << "\n\nPodaj L.p.: ";
//    cin >> temp.number;

    cout << "Podaj Nazwe produktu: ";
    cin >> temp.name;

    cout << "Podaj ilosc: ";
    cin >> temp.amount;

    cout << "Podaj jednostki: ";
    cin >> temp.unit;

    cout << "Podaj cene: ";
    cin >> temp.price;

    temp.value = temp.price * temp.amount;

    base->dodaj(temp);



}
//---------------------------------------------------------------------------
//funkcja odpowiadajca za usuwanie elementu z bazy
void usun(void){
}
//---------------------------------------------------------------------------
//funkcja odpowiadajca za modyfikacje elementu bazy
void modyfikuj(void){


}
//---------------------------------------------------------------------------
//funkcja tymczasowa
void temp() {

}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
int main(int argc, char* argv[])
{
  clrscr();

  char path[path_len];

  do {
    clrscr();
    cout << "Podaj sciezke do pliku z baza:\n#";
    cin >> path;
    if ((access(path, 0) != 0) && (access(path, 6) != 0)) {
      cout << "plik nie istnieje, utworzyc? [T/N]#";

      if (tolower(getch()) == 't') {
        ofstream tmp;
        tmp.open(path, ios::out);
        tmp.close();
      }
      else {
        return 0;
      }
    }
  }
  while((access(path, 0) != 0) && (access(path, 6) != 0));

  baza base(path);

  while(true) {
    switch ( menu(path) ) {
      case '1' : {
        clrscr();
        base.wyswietl(0);
        break;
      }
      case '2' : {
        clrscr();
        wyszukaj(&base);
        break;
      }
      case '3' : {
        clrscr();
        dodaj(&base);
        break;
      }
      case '4' : {
        usun();
        break;
      }
      case '5' : {
        modyfikuj();
        break;
      }
      case 't' : {
        temp();
        break;
      }
      case 27 : // klawisz ESC
      case '0' : {
        return 0;
        //exit(EXIT_SUCCESS);
      }
      default : {
        cout << "\nbledny wybor!";
        getch();
      }
    }
  }
}
//---------------------------------------------------------------------------



