/** @file MTParserExcepStrEng.h
	@brief Default english exception message formatter
	@author (c) 2005 Mathieu Jacques
*/

#ifndef _MTPARSEREXCEPSTRENG_INCLUDED
#define _MTPARSEREXCEPSTRENG_INCLUDED

#include "MTParserException.h"

/** @brief English exception message formatter

	Format exceptions to readable english
	messages. 
*/
class MTParserExcepStrEng
{
public:

	/** @brief Format an exception
	@param data	The definition exception's date
	@return An english message describing the exception
	*/
	static MTSTRING format(const MTExcepData &data);	

private:

	MTParserExcepStrEng();
	void addExcep(const MTCHAR *id, const MTCHAR *msg);

	MTSTRING internalFormat(const MTExcepData &data);	

private:

	static MTParserExcepStrEng m_instance;
	
	struct SExcepInfo
	{
		MTSTRING id;
		MTSTRING msg;
	};

	std::vector<SExcepInfo> m_exceps;	

};


#endif