//#pragma hdrstop
/* satorparserv_use.h;  Version DOUBLE 29d-7m-2004;  Author: Artur Czekalski ARTUR@epokaY.net  www.epokaY.net/artur/ 
 This is a header file with declaration class ObliczanieWyrazenia (ExpressionEvaluate)
 for application, which use satorparserv.dll library.

 This library can be used freely only for noncomercial programs (so-called freeware)
 under condition of placeing an information about author of this library in the program.
*/
//---------------------------------------------------------------------------
#ifndef Unitparser
#define Unitparser

#define DLL_EXP __declspec(dllimport) //IMPORT

//--------------Deklaracje staych-------------------------------------------
extern const char * const StalyErr[]; //dla Unit_Wart.cpp
extern const double TabStalych[]; //dla Unit_Wart.cpp

const int MaxDlWyr = 512;
const int MaxDlTabLiczb = MaxDlWyr/2+1;//max wielko np. "1+x+y" DlWyr.=5; 5/2+1=3 -s 3 liczby/zmienne
const int MaxDlTasmaNormal = MaxDlWyr*2; //np. "2x2y3x"; +1 na znacznik koca =-1

//---------------------------------------------------------------------------
class DLL_EXP ObliczanieWyrazenia
{
private:
 int LZmiennych; //liczba zmiennych
 const char **NazwaZmiennej; //tablica wskanikw na acuch znakw; [0..LZmiennych-1][] (stay)
 const double **AdresZmiennej; //tablica wskanikw na liczby double (stae)
 int DlWyrazenia; //dugo acucha z wyraeniem

 struct Tasma
  {int typ; //typ atomu: liczba, staa, zmienna, operator, funkcja1-4, na pocztku =-1
   int nr; //nr z tablicy danego typu atomu
  } TasmaNormal[MaxDlTasmaNormal], //zawiera kolejne odczytane atomy z wyraenia
    TasmaONP[MaxDlTasmaNormal], //zawiera atomy po przetumaczeniu na ONP
    StosONP[MaxDlWyr]; //stos uywany przy zamianie na ONP

 int TasmaONP2[MaxDlTasmaNormal*2+1]; //(+1 na znacznk koca) Zawiera bdzie to samo co TasmaONP, ale bdzie szybszy dostp

 double TabLiczb[MaxDlTabLiczb]; //tablica - przechowuje odczytane wartoci liczb (po ew. zamianie na dec)
 double StosWart[MaxDlWyr]; //stos do zapisywania porednich wynikw w obliczaniu kocowej wartoci

//---funkcje od rozpoznawania atomw i kodowania ich do TasmaNormal
 int CzyStala(char *&S); //operandy
 int CzyLiczba(char *&S); 
 int CzyZmienna(char *&S);
 
 int CzyOperator(char *&S);
 int CzyFunkcja(char *&S);
 
 int SprNawiasy(void);
 int SprSyntakse(void); //I. sprawdzanie syntaksy
//-------------------------------
 int SprGramatyke(void) const;//II. sprawdzanie gramatyki
 int Nadwyrazenie(int) const;
 int Wyrazenie(int) const;
 int Skladnik(int) const;
 int Nadczynnik(int) const;
 int Sczynnik(int) const;
 int Czynnik(int) const;
//-------------------------------
 int Priorytet(Tasma); //zwraca priorytet atomu
 void ZamienNaONP(void); //III. zamienia na posta ONP
 
public:
 ObliczanieWyrazenia(); //CONSTRUKTOR 1
 ObliczanieWyrazenia(int _LZmiennych, //Number of variables
                     const char **_NazwaZmiennej, //VariableName
                     const double **_AdresZmiennej, //VariableAddress
                     const char *_Wyrazenie); //expression; CONSTRUKTOR 2: it calls Parsuj()
 
 void Parsuj(int _LZmiennych,
             const char **_NazwaZmiennej, 
             const double **_AdresZmiennej,
             const char *_Wyrazenie); //IV.
 
 char LWyrazenie[MaxDlWyr]; //contains copied expression given in the constructor

 int DlTsmN, //length of TasmaNormal = number of all atoms in the expression
     DlTsmONP, //length of TasmaONP = number of operations + number of operands in the expression!!!when >0, you can evaluate the expr.
     DlTabL; //length of TabLiczb = number of numbers in the expr.
 int DlGram; //how long (number of  atoms) is gramtically correct part of tape 
   //if the expr. is not correct, then DlGram < DlTsmN, else is is =.

 char *GSB; //WhereSyntaxError - points to found syntax error in the expr.
 const char *OpisBledu, //ErrorDescription
            *OstOpisBleduW; //former Error Description of evaluationin
 double Haslo; //password
 double WartoscWyrazenia(void); //ExpressionEvaluation on the basis of AdresZmiennej
};
#endif
