/* Example of using class ObliczanieWyrazenia from satorparserv.dll library (ver.29d-7m-2004)
 in console application.
Remark: satorparserv.dll2 - is more safe version it can handle erros like: _DOMAIN,_SING,_OVERFLOW,_PLOSS,_TLOSS,_UNDERFLOW.
 it is a little slower then the version above. (to use it remove sign '2' from the name.)
Version of this program: 21d-7m-2004;  Author: Artur Czekalski  ARTUR@epokaY.net  www.epokaY.net/artur/ 
*/
//---------------------------------------------------------------------------
//#define TEST

#if defined(TEST)
 #include <windows.h> //GetTickCount()
#endif

#include <stdio.h> //printf
//#include <math.h>
#include "satorparserv_use.h" //declaration of class ObliczanieWyrazenia [ExpressionEvaluation]
 //There must be file satorparserv.lib in the directory of the project

#if !defined(TEST)
 double gX = 10.0,  gY = 3.0; //global real variables
 const double *Adresyzmiennych[2]={&gX, &gY}; //this array can not be destroyed during evaluation!
#endif
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void main(void)
{
#if !defined(TEST)
 const char *Nazwyzmiennych[2]={"x","y"}; //variables names which can be used in the expression

 //---Object creation---
 ObliczanieWyrazenia Wyr(2,Nazwyzmiennych,Adresyzmiennych,"x/y-3,0+1.0"); //1-st way -creation and parsing at once
 //ObliczanieWyrazenia Wyr; Wyr.Parsuj(2,Nazwyzmiennych,Adresyzmiennych,"x+y+1.0"); //2-nd way
 //ObliczanieWyrazenia Wyr(0,0,0,"1+sqrt(9)"); //when you don't use variables (here 1-st way)
 printf("Expression: %s\n", Wyr.LWyrazenie);
 printf("Number od atoms from left in gramaticlly correct part of expression: %d\n", Wyr.DlGram);

 if (Wyr.OpisBledu) //check if there is any error in NOTATION of the expression
  {printf("The expression is not correct: %s\n",Wyr.OpisBledu); //description
   if (Wyr.GSB) printf("The error starts from: %s\n",Wyr.GSB); //Where Syntax Error occured
   getchar(); return;
  }

 //(Here is now: Wyr.DlTsmONP > 0, so you can evaluate)

 //----------Evaluation - single-----------
 printf("\n########1234567890123456789012345678901234567890\n");
 printf(  "Value=%.20f\n", Wyr.WartoscWyrazenia());
 if (Wyr.OpisBledu) //check if there was any error in EVALUATION (e.g. dividing by zero)
  printf("%s\n", Wyr.OpisBledu); 


 int i;
 //----------Evaluation - repeatedly--------- 
 printf("\nValues of the expression for sequence of variable values:\n");
 for (i=0; i<8; i++)
  {gX = i;  gY = i-2.0; //when i==2, dividing by zero will occure
   printf("%f\n", Wyr.WartoscWyrazenia());
  } 

 if (Wyr.OstOpisBleduW) //check if there was any error during last evaluations
  printf("Last error during evaluation:\n%s\n", Wyr.OstOpisBleduW); 

 printf("\nThe End!");

#else
 //--------TESTS of SPEED-----------
 double gX = 0.0;
 const double *AdrZm[1]={&gX};
 const char *Nazwyzmiennych[2]={"x"};
 // ObliczanieWyrazenia Wyr(1,Nazwyzmiennych,AdrZm,"sin(x)*x+x+1");
 ObliczanieWyrazenia *Wyr = new ObliczanieWyrazenia(1,Nazwyzmiennych,AdrZm,"sin(x)*x+x+1"); //faster
 printf("Value=%.20f\n", Wyr->WartoscWyrazenia());

 int a,b,i;  double w;
 printf("\nTest: START-press Enter"); getchar();
 a = GetTickCount();
 for (i=0; i<10000000; i++)
  {w = Wyr->WartoscWyrazenia();
   gX+=0.0001;
  }
 b = GetTickCount();
 printf("\nThe End! Time: a=%d; b=%d; b-a=%d",a,b,b-a);
 delete Wyr;
#endif
 
 getchar();
}
/*At first sorry for my english - I'am not english speaking person.
But I think it is very simple to use the class.
Questions, propositions, requests - just email me.
*/