/* satorparserv_use.h;  Wersja DOUBLE 17d-7m-2005;  Autor: Artur Czekalski  ARTUR@epokaY.net  www.epokaY.net/artur/ 
 Plik nagwkowy deklaracji klasy ObliczanieWyrazenia
 dla uycia przez aplikacj, wykorzystujc bibliotek satorparserv.dll.

 Ta biblioteka moe by bezpatnie wykorzystwana tylko w bezpatnych programach, tzw. freeware,
 pod warunkiem umieszczenia w tym programie informacji o autorze tej biblioteki.
*/
//---------------------------------------------------------------------------
#ifndef Unitparser
#define Unitparser

#define DLL_EXP __declspec(dllimport) //IMPORT

//--------------Deklaracje staych-------------------------------------------
const int LStalych = 15;

const int MaxDlWyr = 1024;
const int MaxDlTabLiczb = MaxDlWyr/2+1; //max wielko np. "1+x+y" DlWyr.=5; 5/2+1=3 -s 3 liczby/zmienne
const int MaxDlTasmaNormal = MaxDlWyr*2; //np. "2x2y3x"; +1 na znacznik koca =-1

//---------------------------------------------------------------------------
class DLL_EXP ObliczanieWyrazenia
{
private:
 int LZmiennych; //liczba zmiennych
 const char **NazwaZmiennej; //tablica wskanikw na acuch znakw; [0..LZmiennych-1][] (stay)
 const double **AdresZmiennej; //tablica wskanikw na liczby double (stae)
 int DlWyrazenia; //dugo acucha z wyraeniem

 struct Tasma
  {int typ; //typ atomu: liczba, staa, zmienna, operator, funkcja1-4, na pocztku =-1
   int nr; //nr z tablicy danego typu atomu
  } TasmaNormal[MaxDlTasmaNormal], //zawiera kolejne odczytane atomy z wyraenia
    TasmaONP[MaxDlTasmaNormal], //zawiera atomy po przetumaczeniu na ONP
    StosONP[MaxDlWyr]; //stos uywany przy zamianie na ONP

 int TasmaONP2[MaxDlTasmaNormal*2+1]; //(+1 na znacznk koca) Zawiera bdzie to samo co TasmaONP, ale bdzie szybszy dostp

 double TabLiczb[MaxDlTabLiczb]; //tablica - przechowuje odczytane wartoci liczb (po ew. zamianie na dec)
 double StosWart[MaxDlWyr]; //stos do zapisywania porednich wynikw w obliczaniu kocowej wartoci

//---funkcje od rozpoznawania atomw i kodowania ich do TasmaNormal
 int CzyStala(char *&S); //operandy
 int CzyLiczba(char *&S); 
 int CzyZmienna(char *&S);
 
 int CzyOperator(char *&S);
 int CzyFunkcja(char *&S);
 
 int SprNawiasy(void);
 int SprSyntakse(void); //I. sprawdzanie syntaksy
//-------------------------------
 int SprGramatyke(void) const;//II. sprawdzanie gramatyki
 int Nadwyrazenie(int) const;
 int Wyrazenie(int) const;
 int Skladnik(int) const;
 int Nadczynnik(int) const;
 int Sczynnik(int) const;
 int Czynnik(int) const;
//-------------------------------
 int Priorytet(Tasma) const; //zwraca priorytet atomu
 void ZamienNaONP(void); //III. zamienia na posta ONP
 
public:
 ObliczanieWyrazenia(); //KONSTRUKTOR 1
 ObliczanieWyrazenia(int _LZmiennych,
                     const char **_NazwaZmiennej, 
                     const double **_AdresZmiennej,
                     const char *_Wyrazenie); //KONSTRUKTOR 2: wywouje Parsuj()
 
 void Parsuj(int _LZmiennych,
             const char **_NazwaZmiennej, 
             const double **_AdresZmiennej,
             const char *_Wyrazenie); //IV.
 
 char LWyrazenie[MaxDlWyr]; //zawiera skopiowane wyraenie podane w konstruktorze

 int DlTsmN, //dugo TasmaNormal = liczba wsz. atomw w wyraeniu
     DlTsmONP, //dugo TasmaONP = liczba dziaa + liczba operandw w wyraeniu;!!!gdy>0, to mona oblicza wyraenie
     DlTabL; //dugo TabLiczb = liczba liczb w wyraeniu; ustala CzyLiczba()

 int DlGram; //jak duga (liczba atomw) jest poprawna gramatycznie cz tamy
   //jeli wyraenie jest niepoprawne, to DlGram<DlTsmN inaczej jest =.

 char *GSB; //GdzieSyntaxBd -wskazuje gdzie w wyraeniu znaleziono bd syntaktyczny
 const char *OpisBledu, //wsk. na stay string (tzn., ktrego nie mona zmienia)
            *OstOpisBleduW; //poprzedni ops bdu obliczania wartoci
 static double Haslo; //deklaracja
 double WartoscWyrazenia(void); //na podstawie AdresZmiennej
};
#endif