//EquTranslator.pas
//Copyright  2001-2005Easy Math Solution. All Rights Reserved
//http://www.e-MathSolution.com
//For details contact us: info@e-MathSolution.com

unit EquTranslator;

interface

uses
  SysUtils;

type
        TpDbl =^double;
        TpFunction=^TFunction;
        TpFuncError=^TFuncErr;
        TFunction=function(ar:double):double;
        TFuncErr=procedure(er:string);


//Interface of EquTranslator.dll
        function EvaluateEqu(exp:PChar; arg:TpDbl):double; stdcall;
        function Evaluate(varList:PChar; exp:PChar; arg:TpDbl):double; stdcall;
        procedure BuildEqu(exp: PChar);stdcall;
        procedure Build(varList:PChar; exp:PChar); stdcall;
        function CalcFor(arg:TpDbl):double; stdcall;
        function AddFunction(name:PChar;fn:TpFunction):boolean ;stdcall;
        function RemoveFunction(name:PChar):boolean ;stdcall;
        function AddConst(name:PChar;fn:double):boolean ;stdcall;
        function RemoveConst(name:PChar):boolean ;stdcall;
        procedure SetErrorHandle(errF:TpFuncError);stdcall;


implementation
        function EvaluateEqu; external 'Equtranslator.dll';
        function Evaluate; external 'Equtranslator.dll';
        procedure BuildEqu; external 'Equtranslator.dll';
        procedure Build; external 'Equtranslator.dll';
        function CalcFor; external 'Equtranslator.dll';
        function AddFunction; external 'Equtranslator.dll';
        function RemoveFunction; external 'Equtranslator.dll';
        function AddConst; external 'Equtranslator.dll';
        function RemoveConst; external 'Equtranslator.dll';
        procedure SetErrorHandle; external 'Equtranslator.dll';


//Native function to raise exception
procedure RiaseException(err:PChar);stdcall;
begin
        raise   Exception.Create(err);
end;


initialization
        //Init error handle
        SetErrorHandle( @RiaseException );
end.
