program EquTrDemo;
{$APPTYPE CONSOLE}
uses
  SysUtils, EquTranslator, windows;

  //User defined function (grades to radians).
function toRad(var x:double):double; stdcall;
begin
        toRad:=x*3.14/180;
end;

var
  args:array[0..2] of double;
  res:double;
  twoPi:double;
  mathFunc:PChar;
  mathExp:PChar;
  varList:PChar;

 begin

 args[0]:=2;
 args[1]:=5.6;
 args[2]:=-11;
   twoPi:=6.28;

  mathFunc := 'F(x, y, z) = 3*x^2-y^2+exp(toRad(45))/twoPi';
  mathExp := '3*x^2-y^2+sqrt(toRad(85))/twoPi';
  varList := 'x y z';

    try
        AddFunction('toRad', @toRad);
        AddConst('twoPi', twoPi);

        BuildEqu(mathFunc);
	res := CalcFor(@args);
	writeln('res=',res);

	RemoveFunction('toRad');
	Build('', 'twoPi/2');
	res := CalcFor(@args);
	writeln('res=',res);

	AddFunction('toRad', @toRad);
	res := EvaluateEqu(mathFunc, @args);
	writeln('res=',res);

	RemoveConst('twoPi');
	res :=Evaluate(varList, mathExp, @args);//Error
	writeln('res=',res);


    except
          on E:Exception do writeln('Exception: '+e.Message);

        end;

   readln;
 end.

