
#include "EquTranslatorEx.h"


TEvaluateEqu            EvaluateEqu;
TEvaluate               Evaluate;
TBuildEqu       	BuildEqu;
TBuild                  Build;
TCalcFor                CalcFor;
TAddFunction            AddFunction;
TRemoveFunction         RemoveFunction;
TAddConst               AddConst;
TRemoveConst            RemoveConst;
TSetErrorHandle         SetErrorHandle;
HINSTANCE hDLL=NULL;


#if defined(__BORLANDC__)
void __stdcall ErrorHandler(const TCHAR*err) throw( EquException)
{
        throw EquException(err);
}
#endif


bool LoadEquTranslator(void)
{
#if defined(_UNICODE)
        if((hDLL = LoadLibrary(_T("EquTranslatorW.dll")))==NULL)
#else
        if((hDLL = LoadLibrary(_T("EquTranslator.dll")))==NULL)
#endif
                return false;

        EvaluateEqu=(TEvaluateEqu)GetProcAddress(hDLL,_T("EvaluateEqu"));
        Evaluate=(TEvaluate)GetProcAddress(hDLL,_T("Evaluate"));
        BuildEqu=(TBuildEqu)GetProcAddress(hDLL,_T("BuildEqu"));
        Build=(TBuild)GetProcAddress(hDLL,_T("Build"));
        CalcFor=(TCalcFor)GetProcAddress(hDLL,_T("CalcFor"));
        AddFunction=(TAddFunction)GetProcAddress(hDLL,_T("AddFunction"));
        RemoveFunction=(TRemoveFunction)GetProcAddress(hDLL,_T("RemoveFunction"));
        AddConst=(TAddConst)GetProcAddress(hDLL,_T("AddConst"));
        RemoveConst=(TRemoveConst)GetProcAddress(hDLL,_T("RemoveConst"));
        SetErrorHandle=(TSetErrorHandle)GetProcAddress(hDLL,_T("SetErrorHandle"));

        if( !EvaluateEqu ||  !Evaluate ||   !BuildEqu ||   !Build ||
            !CalcFor || !AddFunction || !RemoveFunction || !AddConst ||
            !RemoveConst || !SetErrorHandle)
            return false;

#if defined(__BORLANDC__)
        SetErrorHandle(ErrorHandler);
#endif

        return true;
}

//////////////////////////////////////////////////////////////////
//
void UnLoadEquTranslator(void)
{
        SetErrorHandle(NULL);
        if(hDLL)
                FreeLibrary(hDLL);
}



