//---------------------------------------------------------------------------

#include <windows.h>



#include<string>
#include <cmath>
#include <iostream.h>
#include <windows.h>

#include"EquTranslatorEx.h"


//User defined function
const TCalc __stdcall toRad(const TCalc& x)
{
	return 3.14/180;
}


int _tmain(int argc, _TCHAR* argv[])
{
        TCalc args[] = {2, 5.6, -11};
        TCalc res,twoPi=6.28;      //user defined const


	//Math expressions
    TCHAR *mathFunc = _T("F(x, y, z) = 3*x^2-y^2+exp(toRad(45))/twoPi");
    TCHAR *mathExp = _T("3*x^2-y^2+sqrt(toRad(85))/4.45+twoPi");
    TCHAR *varList = _T("x y z");


	if(!LoadEquTranslator())
        exit(1);

	try{

		AddFunction(_T("toRad"), toRad);
		AddConst(_T("twoPi"), twoPi);

	        BuildEqu(mathFunc);
		res = CalcFor(args);
		cout<<"Res="<<res<<endl;


		Build(_T(""), _T("twoPi/2"));
		res = CalcFor(args);
	        cout<<"Res="<<res<<endl;

		res = EvaluateEqu(mathFunc, args);
		cout<<"Res="<<res<<endl;

		RemoveConst(_T("twoPi"));
		res=Evaluate(varList, mathExp, args); //Error.
		cout<<"Res="<<res<<endl; 

	} catch(EquException &e) {
		std::cout<<e.what().c_str();
		}

        UnLoadEquTranslator();
	return 0;
}
