using System;
using EMS;


namespace CSH_test
{
	class Test
	{
		[STAThread]
		static void Main(string[] args)
		{
			double [] arg= new double[2];
			double res=0;
			string mExp="f(x,y)=x+(5+y)^2-exp(x)";
			arg[0]=5; arg[1]=6;
			try
			{
				EMS.EquTranslator.SetEquTranslateException();
				EMS.EquTranslator.AddConst("pi2", 6.28);

				EMS.EquTranslator.BuildEqu("f(x,y)=sin(pi2)+x-y");
				res=EMS.EquTranslator.CalcFor(arg);
				
				Console.WriteLine("res="+
					EMS.EquTranslator.EvaluateEqu(mExp, arg));

				EMS.EquTranslator.RemoveConst("pi2");

			} 
			catch(Exception e)
			{
				Console.WriteLine(e.Message);
			}

			Console.WriteLine("res="+res);
			
		}
	}
}
