clear variables;
global err;
clc
if exist('mapa_kolorow')==0 load dane; end; %ladowanie palety kolorow

okno1=figure('Name','Numeryczne metody optymalizacji',...
	'Units','normalized',...
	'NumberTitle','off',...
	'keypressfcn','okno1','MenuBar','none',...
	'Colormap',mapa_kolorow,...
	'Color',[0.6 0.6 0.1],...
	'Position',[0.05 0.15 0.9 0.75]);


[x,y]=meshgrid((-1:.1:2)*pi,(-1:.1:2)*pi);
z=(sin(x).*cos(y)+4*exp(-(x-.5).^2-(y-.5).^2));
surf(x,y,z);
axis([0 25 0 25 -1.5 6]);
text(0,0.95,'Numeryczne metody optymalizacji',...
	'Units','normalized',...
	'Color','b',...
	'FontName','Times',...
	'FontAngle','italic',...
	'FontWeight','bold',...
	'FontSize',26);
text(0.1,0.87,'funkcji wielu zmiennych bez ogranicze',...
	'unit','normalized','color','b',...
	'fontname','times','fontangle','italic','fontsize',16);
text(0.8,0.82,'v. 1.05a','unit','normalized','color','b',...
	'fontname','times','fontangle','italic','fontsize',16);

text(-0.12,-0.1,'Praca dyplomowa 98/99. Wykona: Jacek Grabowski   Pod kierunkiem: prof. Jerzego witka',...
	'unit','normalized','fontname','times','fontsize',10);


whitebg([.6 .6 0]);
axis off;


%przyciski 

at=0.6;
bt=0.055;
szer=0.33;
wys=0.053;
% wyswietlenie napisow na stronie tytulowej
text(-.14,0.72,'     Metody bezgradientowe ',...
	'Units','normalized',...
	'Color','y',...
	'FontName','Times',...
	'FontAngle','normal',...
	'FontWeight','bold',...
	'FontSize',14);


text(0.48,0.72,'                   Metody gradientowe ',...
	'Units','normalized',...
	'Color','y',...
	'FontName','Times',...
	'FontAngle','normal',...
	'FontWeight','bold',...
	'FontSize',14);


% przyciski na stronie tytulowej

N=4;
nazwa_metody=str2mat(['Hooka-Jevesa','Rosenbrocka','Neldera i Meada',...
	'Powella','Gradientowe proste','Newtona','Davidona-Fletchera-Powella','Fletchera-Reevsa'],...
	['12','11','15','07','18','07','26','16']); 
dzialanie=str2mat(['hj01','r01','nm01','pow01','ns01','n01','dfp01','fr01'],...
	['04','03','04','05','04','03','05','04']);

for i=0:N-1,
	
	uicontrol('style','pushbutton',...
		'Units','normalized',...
		'position',[bt at-i*0.1 szer wys],...
		'string',mat21str(nazwa_metody,i+1),...
		'callback',mat21str(dzialanie,i+1));

	uicontrol('style','pushbutton',...
		'Units','normalized',...
		'position',[bt+0.560 at-i*0.1 szer wys],...
		'string',mat21str(nazwa_metody,i+5),...
		'callback',mat21str(dzialanie,i+5));
end

uicontrol('style','pushbutton',...
		'units','normalized',...
		'position',[bt 0.1 szer wys],...
		'string','Metody optym. w kierunku',...
		'callback','zzkierun');

uicontrol('style','pushbutton',...
	'Units','normalized',...
	'position',[0.88 0 0.12 0.05],...
	'string','Koniec',...
	'callback','close all;clear');
uicontrol('style','pushbutton',...
	'Units','normalized',...
	'position',[0.88 0.06 0.12 0.05],...
	'string','Drukarka',...
	'CallBack','Opcje');