% 	MINIMALIZACJA FUNKCJI JEDNEJ ZMIENNEJ
%
%	***** METODA PODZIAU DYCHOTOMICZNEGO *****
%
%
%	Wieloksci wyjsciowe: 
%		Mat - macierz o wymiarach (n,9)	gdzie: n - il. krokow
%
%		Mat=| 	1	a1	f(a1)	b1	f(b1)	l1	f(l1)	m1	f(m1) |
%		    |	.	.	.	.	.	.	.	.	.     |
%		    |	n	an	f(an)	bn	f(bn)	ln	f(ln)	mn	f(mn) |
%
%		minf=[a*,b*]	
%		iter - ilosc wykonanych iteracji
%
%	Wielkosci wejsciowe:
%		[a,b]	- przedzial w ktorym ma byc poszukiwane minimum
%		ep	- ep>0 - wielkosc o jaka beda przesuwane granice 'a' i 'b' 
%		l	- warunek stopu:   b-a < l
%		n	- wielkosc potrzebna ze wzgledu na rekurencyjny charakter funkcji
%			  wartosc na starcie nalezy podac =1
%		fun	- nazwa funkci ktora badamy np. 'f1'
%			  gdzie: f1 jest funkcja postaci y=f1(x)
%
function [Mat,minf,iter,F_iter]=dychotom(a,b,ep,l,n,fun,par)
	iter=n-1;
	if (iter>202),
		minf=[a b];
		F_iter=iter*2;
		return ;
	end

	if (abs(b-a)<l),
		Mat(n,1)=n-1;
		Mat(n,2)=a;
		Mat(n,3)=eval([fun '(par,a)']);
		Mat(n,4)=b;
		Mat(n,5)=eval([fun '(par,b)']);
		minf=[a b];
		iter=n;
		F_iter=iter*2;
		return;
	end

	ln=(a+b)*0.5-ep;
	mn=(a+b)*0.5+ep;
	[a b ln mn ep];

	ap=a;
	bp=b;
	if (eval([fun '(par,ln)'])<eval([fun '(par,mn)'])),
		b=mn;
	else
		a=ln;
	end
	n=n+1;
	[Mat minf iter F_iter]=dychotom(a,b,ep,l,n,fun,par);
	
	Mat(n-1,1)=n-1;
	Mat(n-1,2)=ap;
	Mat(n-1,3)=eval([fun '(par,ap)']);
	Mat(n-1,4)=bp;
	Mat(n-1,5)=eval([fun '(par,bp)']);
	Mat(n-1,6)=ln;
	Mat(n-1,7)=eval([fun '(par,ln)']);
	Mat(n-1,8)=mn;
	Mat(n-1,9)=eval([fun '(par,mn)']);
	