%
% AMBI pokazuje niejednoznacznosc sprobkowanego przebiegu
%
% Podstawy i algorytmy przetwarzania sygnalow
% semestr letni 2005
%

clg
clc
FS = [120,1320];	% czestotliwosc sygnalu [Hz]
FP = 1200;	% czestotliwosc probkowania
T = 0.01;	% przedzial probkowania [s]
% odstep probkowania
dt = 1/FP;
ile = length(FS);

for i = 1:ile
	fs=FS(i);
	% chwile w ktorych pobierane sa probki
	t_samp = 0:dt:T;
	% momenty probkowania dla sygnalu ,,ciaglego''
	t_cont = 0:(1./(20*fs)):T;
	% sygnal ciagly
	signal_cont = sin (2*pi*fs*t_cont);
	% sygnal sprobkowany
	signal_samp = sin (2*pi*fs*t_samp);
	
	subplot(ile,1,i); clg
	title(['fs = : ',int2str(fs),', fp = ',int2str(FP)]);
	xlabel('czas [s]');
	ylabel('amplituda')
	grid
	% wykres sygnalu ,,ciaglego''
	plot(t_cont,signal_cont,'b-');
	hold on
	% probki
	plot(t_samp,signal_samp,'r*');
	% odtworzenie na podstawie probek
	plot(t_samp,signal_samp,'k-');
	hold off
endfor
%legend('off')