% PRZECIEKWIN pozwala na eksperymentowanie z wplywem okienkowania na analize czestotliwosciaowa sygnalu
%
%============================================
%	Wybor parametrow symulacji
%============================================
oneplot;
clg;
L = 512;				% dlugosc sygnalu
f0 = 0.40;			% czestotliwosc znormalizowana (fs=1) dla sygn x1
f1 = 0.38;			% czestotliwosc znormalizowana (fs=1) dla sygn x2
f2 = 0.42;			% czestotliwosc znormalizowana (fs=1) dla sygn x2
%win = blackman(L)';		% wybor okna
%win = gausswin(L)';		% wybor okna
win = hamming(L)';		% wybor okna
win = kaiser(L,0.5)';		% wybor okna

A = poly(f0);
[h w] = freqz(A);
win = h;
%win = w;

% wybor sposobu prezentacji wynikow DFT:
%	 1 - skala log, 0 - skala liniowa
POKAZ_W_SKALI_LOGARYTMICZNEJ = 1;

n = 1:L;
x1 = cos(2*pi*f0*n);
x2 = cos(2*pi*f1*n)+cos(2*pi*f2*n);
x3 = rand(1,L);

% wybor sygnalu do analizy (x1 lub x2)
x = x3;
%============================================
% czy wystapi przeciek widma?
df = 1/L;
disp(["Rozdzielczosc czestotliwosciowa df =",num2str(1/L)])
disp(["f0 wypada na: ",num2str(f0/df)," prazek"]);
disp(["f1 wypada na: ",num2str(f1/df)," prazek"]);
disp(["f2 wypada na: ",num2str(f2/df)," prazek"]);

% okienkowanie sygnalu
xw = x .* win;

X = abs(fft(x));		% modul DFT
if POKAZ_W_SKALI_LOGARYTMICZNEJ
	X = 20*log10(X);		% skala logarytmiczna
endif

XW = abs(fft(xw));		% modul DFT
if POKAZ_W_SKALI_LOGARYTMICZNEJ
	XW = 20*log10(XW);		% skala logarytmiczna
endif

skalaF = (n-1)./L;
polowaL = ceil(L/2); 
skalaF = skalaF(1:polowaL);

% skalowanie zakresu osi
osX = [min(skalaF),max(skalaF)];
osY = [0, 1.2*max(max(X), max(XW))];

% opisy osi
if POKAZ_W_SKALI_LOGARYTMICZNEJ
	ytytul = "20log( |X(f)| ) [dB]";
else
	ytytul= "|X(f)|";
endif
xtytul = "czestotliwosc znormalizowana (fs = 1)";

% legenda
opis = ["DFT sygn. niezokienkowanego,  "];
opisW = ["DFT sygn. zokienkowanego,  "];
tekst1 = sprintf(" f0 = %1.2f,  df = %1.2f",f0,df);
tekst2 = sprintf(" f1 = %1.2f,  f2 = %1.2f,  df = %1.2f",f1,f2,df);
if x == x1
	opis = [opis,tekst1];
	opisW = [opisW,tekst1];
else
	opis = [opis,tekst2];
	opisW = [opisW,tekst2];
endif;


% sygnaly
%oneplot();clg;grid "on";
%plot(n, xw,'-r;sygnal zokienkowany;');
%ylabel("amplituda x(n)");
%axis("auto");replot

% bez okienkowania
subplot(2,1,1);clg;grid "on"
plot(skalaF, X(1:polowaL), ['^;',opis,';']);
ylabel(ytytul);
xlabel(xtytul);
axis([osX , osY]);replot;

% z okienkowaniem
subplot(2,1,2);clg;grid "on";
plot(skalaF, XW(1:polowaL), ['^;',opisW,';']);
ylabel(ytytul);

	
xlabel(xtytul);
axis([osX , osY]);replot;
