
% ------------------------------------------------------------------------------------------
% Skrypt z Tomasz P. Zieliski "Od teorii do cyfrowego przetwarzania sygnaw"
% 	wersja z przerbkami umozliwiajcymi uruchamianie w rodowisku GNU Octave
%
% Tabela 8.2 (str.222)
% wiczenie - Analiza czstotliwociowa sygnaw metod dyskretnego przeksztacenia Fouriera
% ------------------------------------------------------------------------------------------

  clear all; clf;

% Podaj wartoci parametrw analizy
  fp = 16;			%  czstotliwo prbkowania
  df = 1;			%  rozdzielczo czstotliwociowa analizy w Hz
  Asl = 80;			%  rozdzielczo amplitudowa analizy w dB (tumienie listka bocznego) 
  dfn = df/fp;		%  unormowana rozdzielczo analizy w Hz/Hz
  Dml = 2*pi*dfn;	%  szeroko listka gwnego unormowana wzgldem cz. prbkowania

% Obliczenie parametrw okna Kaisera: beta i N
  if (Asl <= 13.26) beta = 0; end
  if (13.26 < Asl & Asl <= 60 ) beta = 0.76609*(Asl-13.26)^0.4 + 0.09834*(Asl-13.26); end
  if (60 < Asl & Asl <= 120) beta = 0.12438*(Asl+6.3); end
  N = ceil( 24*pi*(Asl+12)/(155*Dml) ) + 1
  disp("przycisnij klawisz...")
  pause

% Generacja sygnau - dwie sinusoidy
% N = 200;			% dugo sygnaw: przyjmij arbitralnie lub zastosuj N wyznaczone powyej
  ax1 = 1;			% amplituda sygnau 1
  ax2 = 0.001;		% amplituda sygnau 2
  fx1 = 1;			% czstotliwo sygnau 1 w Hz
  fx2 = 2;			% czstotliwo sygnau 2 w Hz
  fm = 32;			% maksymalna czstotliwo w Hz rysunku widma okresowego
  NF = 1000;		% ilo punktw charakterystyki czstotliwociowej

  dt  = 1/fp; t = 0 : dt : (N-1)*dt;	% chwile prbkowania
  x1  = ax1 * cos( 2*pi*fx1*t );			% sygna 1
  x2  = ax2 * cos( 2*pi*fx2*t );			% sygna 2
  x12 = x1 + x2;								% suma sygnaw 1 + 2

  x = x12;			% wybierz sygna: x1, x2 lub x12

  stem(t,x,'-bo'); axis "normal";grid;
  title('Sygna analizowany'); xlabel('czas [s]');
  disp("przycisnij klawisz...")
  pause

% Generacja okna
  w1 = boxcar(N);			% rne okna
  w2 = bartlett(N);		%
  w3 = hanning(N);		%
  w4 = hamming(N);		%
  w5 = blackman(N);		%
  w6 = kaiser(N,beta);	%
  w = w6;					% wybierz okno: wskazane okno Kaisera
  w = w';					% zamie wektor pionowy na poziomy

  plot(w,'-b'); grid; axis "normal";
  title('Funkcja okna'); xlabel('nr prbki');
  disp("przycisnij klawisz...")
  pause

% Widmo okna - wasna implementacja rwnania (8.8a) 

  df=fp/(NF-1); f = -fp/2:df:fp/2;			% prbkowanie czstotliwoci
  omega=2*pi*f/fp;								% pulsacja unormowana
  n = 0 : N-1;										% indeks czasu
  for k=1:NF										%
     W(k)=sum( w .* exp(-j*omega(k)*n) );	% widmo Fouriera (8.8a) dla k-tego omega
  end							%
  W = abs(W)/N; W = 20*log10(W);				% warto bezwzgldna i normowanie
  plot(f,W,'-b'); grid;  axis "normal";
  title('Modu widma okna w dB'); xlabel('f [Hz]');
  disp("przycisnij klawisz...")
  pause

% x = hilbert(x);		% opcjonalnie zastosuj transformacj Hilberta

  x = x .* w;			% wymn sygna z oknem

%  widmo niesprbkowane (8.8a) okresowe - funkcja Matlaba freqz()
  df = 2*fm/(NF-1); f = -fm:df:fm; 
  X = freqz(x,1,f,fp); X = abs(X)/N; X = 20*log10(X); 
  plot(f,X,'-b'); grid; xlabel('f [Hz]');  axis "normal"; 
  title('Widmo (8.8a) "niesprbkowane" okresowe');
  disp("przycisnij klawisz...")
  pause

%  widmo niesprbkowane (8.8a) jeden okres - funkcja Matlaba freqz()
  [X1,f1] = freqz(x,1,NF,'whole',fp); X1 = abs(X1)/N; X1 = 20*log10(X1); 
  plot(f1,X1,'-b'); grid; xlabel('f [Hz]'); 
  title('Widmo (8.8a) "niesprbkowane - jeden okres"'); pause

%  widmo sprbkowane DFT (8.13a), tylko jeden okres - program wasny
  n=0:N-1; 
  for k=0:N-1
     X2(k+1)=sum( x.* exp(-j*2*pi*k*n/N) ); 
  end
  f0 = 1/(N*dt); f2 = 0:f0:(N-1)*f0; X2 = abs(X2)/N; X2 = 20*log10(X2); 
  plot(f1,X1,'-b',f2,X2,'bo'); 
  grid; xlabel('f [Hz]'); title('Widma - porwnanie freqz() i moje dft()');
  disp("przycisnij klawisz...")
  pause

% widmo "sprbkowane" DFT (8.13a), tylko jeden okres - funkcja Matlaba fft()
  X2 = fft(x); X2 = abs(X2)/N; X2 = 20*log10(X2); 
  plot(f1,X1,'-b',f2,X2,'bo'); 
  grid; xlabel('f [Hz]'); title('Widma - porwnanie freqz() i fft() Matlaba');
  disp("przycisnij klawisz...")
  pause
