%  
% CONVDEMO - demonstracja graficzna funkcji splotu
%
% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005

clear *;

% czyszczenie ekranu graficznego
subplot(1,1,1),clg;

% wektor czasu
t = -20:20;

% dlugosc wektora t
N = length(t);

% sygnal prostokatny o wartosci 1
% dla t=0:9
x = [zeros(1,20), 2, 2, 2, 2 zeros(1,17)];

% sygnal prostokatny o wartosci 1
% dla t=0:4 
y = [zeros(1,20), 1, 2, 3, zeros(1,18)];

% odwrocenie w czasie sygnalu y tj.
% wartosc 1 dla t=-4:0
y = y(N:-1:1);

s = zeros(1,N);
% wykreslanie w petli kolejnych krokow splotu
for k = 1:16
	% iloczyn skalarny sygnalow x i y
	s(k+20) = x * y.';
	
	% wykreslanie wykresow
	subplot(1,1,1),clg;
	xlabel("probki"); ylabel("wartosci");
	subplot(3,1,1);
	plot(t,x,"or;syg x(n);");
	subplot(3,1,2);
	plot(t,x,"or;syg x(n);",t,y,"*b;syg y(k-n);")
	subplot(3,1,3);
	plot(t,s,"^g;splot x(n)y(k-n);",t(k+20),s(k+20),"*r;aktualna probka;");
	
	disp("by wykreslic kolejny krok wcisnij klawisz ...");
	pause;
	
	% rotacja wektora y o 1
	y = [y(N) y(1:N-1)];
	
endfor
