%  
% CONVDEF - wyznaczenie splotu dwoch funkcji
%
% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005

clear *;

% czyszczenie ekranu graficznego
subplot(1,1,1),clg;

% czestotliwosc probkowania
fp = 75;

% wektor czasu
t = [0:1000]./fp;

% dlugosc wektora czasu
N = length(t);

% pierwszy sygnal - sinus 2 i 6 Hz
x = sin(2*pi*5*t) + 2*rand(1,N);

% drugi sygnal - tlumiony sinus
y = sin(2*pi*5*t);

% splot sygnalow x i y
s = conv(x,y);

	% wizualizacja sygnalow 	
	subplot(1,1,1),clg;
	xlabel("czas"); ylabel("wartosci");
	subplot(3,1,1);
	plot(t,x,"-r;syg x(n);");
	subplot(3,1,2);
	plot(t,y,"-r;syg y(n);")
	subplot(3,1,3);
	N = length(s); t = [0:N-1]/fp;
	plot(t,s,"-b;splot s(n);");
	
	disp("by wykreslic widmo FFT sygnalow wcisnij klawisz ...");
	pause;

	% wyznaczenie transformaty fft sygnalow
	X = abs(fft(x)); %X = X / max(X);
	Y = abs(fft(y)); %Y = Y / max(Y);
	S = abs(fft(s)); %S = S / max(S);
	
	N = length(X);
	f = [0:N-1]/(N-1)*fp;
			
	subplot(1,1,1),clg;
	xlabel("czestotliwosc"); ylabel("wartosci");
	subplot(3,1,1);
	plot(f,X,"-r;syg X(f);");
	subplot(3,1,2);
	plot(f,Y,"-r;syg Y(f);")
		
	N = length(S); f = [0:N-1]/(N-1)*fp;
	subplot(3,1,3);
	plot(f,S,"-b;splot S(f);");
	
