%  
% CONVCOR - wyznaczenie korelacji i splotu dla dwoch rznych par sygnalow
%
% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005

clear *;

% czyszczenie ekranu graficznego
subplot(1,1,1),clg;

% czestotliwosc probkowania
fp = 200;

% wektor czasu
t = [0:1000]./fp;

% dlugosc wektora czasu
N = length(t);

% ---------- pierwszy sygnal ---------------
%  impuls prostokatny
% x = zeros(size(t)); x(250:750)=ones(1,501);
%  sinus 2 i 6 Hz
x = exp(-5*t);
%  liniowo narastajacy
%x = zeros(size(t)); x(250:750)=linspace(0,1,501);
%  tlumiony sinus
%x = sin(2*pi*2*t) .* exp(-5*t);
%  sin(x)/x
%x = sin(2*pi*2*(t-N/2/fp)) ./ (2*pi*2*(t-N/2/fp)); 
% ----------- drugi sygnal -----------------
%  impuls prostokatny
%y = zeros(size(t)); y(250:750)=ones(1,501);
%  tlumiony sinus
%y = sin(2*pi*2*t) .* exp(-5*t);
%  sin(x)/x
y = cos(2*pi*2*t);
%  liniowo narastajacy
%y = zeros(size(t)); y(250:750)=linspace(0,1,501);

% splot sygnalow x i y
s = conv(x,y);

% korelacja sygnalow x i y
[Rxy k] = xcorr(x,y);

	% wizualizacja sygnalow 	
	subplot(1,1,1),clg;
	xlabel("czas"); ylabel("wartosci");
	subplot(2,2,1);
	plot(t,x,"-r;syg x(n);");
	subplot(2,2,2);
	plot(t,y,"-r;syg y(n);");
	subplot(2,2,3);
	N = length(s); t = [0:N-1]/fp;
	plot(t,s,"-b;splot x(n)*y(n);");
	subplot(2,2,4);
	plot(k/fp,Rxy,"-b;korelacja Rxy(n);");
	
	
