%ZEROPOLE pokazuje wplyw rozkladu zer i biegunow na odpowiedz impulsowa oraz ch-ki amplitudowe i fazowe

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% kwiecien 2005
% 

%=============================================
% czestotliwosc probkowania [Hz]
%	(wymagana jesli skalowanie ma byc w czestotliwosciac rzeczywistych - nieunormowanych)
fs = 500;

% pierwiastki licznika
zera = [];

% pierwiastki mianownika
%bieguny = -0.9;
fi1 = pi/4;
b1=sin(fi)+i*cos(fi);
b2=sin(fi)-i*cos(fi);
bieguny =[b1, b2];
%bieguny = 0.9*[exp(i*2*pi*((100/fs))),exp(-i*2*pi*(100/fs))];	% para biegunow sprzezonych 
															% odpowiadajacych czestotliwosci 10 
															% przy czestotliwosci probkowania 1000
																												


%opisy osi jako czestotliwosci unormowane (z zakresu [0,1])
% lub rzeczywiste (za zakresu [0, fs], zalezne od czestotliwosci probkowania)
POKAZ_CZESTOTLIWOSCI_UNORMOWANE = 1;

% pokaz ch-ke amplitudow w skali logarytmicznej
POKAZ_W_SKALI_LOGARYTMICZNEJ = 0;

%=============================================
% wspolczynniki wielomianu licznika
b = poly(zera);

% wspolczynniki wielomianu mianownika
a = poly(bieguny);

% kreslenie roz	kladu zer i biegunow
subplot(2,2,1);clg
title('Rozklad zer i biegunow')
xlabel('Re(z)');
ylabel('Im(z)');
axis("square");
zplane([b],[a]);	% uwaga na oznaczenia zer i biegunow!!! Pod linuxem zera to ,,x'' a bieguny to ,,o''
%legend("|z| = 1"),'zera','bieguny');

% kreslenie odpowiedzi impulsowej
subplot(2,2,2);clg;
axis("normal");
[x, t] = impz([b],[a]);			% obliczenie odpowiedzi impulsowej
title('Odpowiedz impulsowa');
xlabel('probki');
ylabel('h(n)');
grid "on";
plot(t,x,'b^');
legend "off"

% obliczenie charakterystyki czestotliwosciowej
[H,w] = freqzz([b],[a]);

% utworzenie opisow osi czestotliwosci dla ch-k amplitudowej i fazowej
if (POKAZ_CZESTOTLIWOSCI_UNORMOWANE)
	opisyCzestotliwosci = w/(2*pi);
	tytulOsiCzestotliwosci = 'unormowana czesotliwosc (fs=1)';
else
	opisyCzestotliwosci = fs*w/(2*pi);
	tytulOsiCzestotliwosci = 'czestotliwosc [Hz]';
endif;

% kreslenie charakterystyki amplitudowej
subplot(2,2,3);clg;
title('Charakterystyka amplitudowa');
xlabel(tytulOsiCzestotliwosci)
ylabel('|H(f)|');
grid "on";
if (POKAZ_W_SKALI_LOGARYTMICZNEJ)
	semilogy(opisyCzestotliwosci, abs(H), 'r-');
else
	plot(opisyCzestotliwosci, abs(H), 'r-');
endif
legend "off";

% kreslenie charakterystyki fazowej
subplot(2,2,4);clg;
title('Charakterystyka fazowa');
xlabel(tytulOsiCzestotliwosci)
ylabel('angle( H(f) )');
grid "on";
plot(opisyCzestotliwosci, angle(H), 'r-');
legend "off";