function [cr] = crosscor(X,Y,tau)
%CROSSCOR oblicza funkcje korelacji wzajemnej sygnalow lacznie stacjonarnych
%	[cr] = CROSSCOR(X,Y,tau)
%
% Oblicza funkcje korelacji wzajemnej sygnalow
% lacznie stacjonarnych X i Y dla zakresu [-tau, tau] punktow
% opoznienia. Podaje wynik symetrycznie dla dodatniej i
% ujemnej czesci osi opoznienia.
%
% Wejscie:
%	X	- pierwszy sygnal stacjonarny
%	Y	- drugi sygnal stacjonarny
%	tau	- opoznienie
%
% Wyjscie:
%	cr	- funkcja korelacji wzajemnej
%

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

[mx,nx]=size(X);
if (nx>mx)
	X=X.';
endif
[my,ny]=size(Y);
if (ny>my)
	Y=Y.';
endif

lenx=max(mx,nx);
leny=max(my,ny);
len=min(lenx,leny);
tau=min(len,tau);

cr=zeros(2*tau+1,1);

for k=(-tau:0)
	cr(k+tau+1)=X(1:len+k).'*Y(-k+1:len)/len;
endfor
for k=(1:tau)
	cr(k+tau+1)=X(k+1:len).'*Y(1:len-k)/len;
endfor


endfunction