% skrypt p1.m
%
% przyklad ilustrujacy zastosowanie FFT (szybka transformata Fouriera)
% dla sygnalu dyskretnego w dziedzinie czasu
% (m-plik)
%
% A0, A1, A2 - amplitudy sinusoid (skladowych sygnalu)
% f0, f1, f2 - czestotliwosci sinusoid skladowych
% t - czas dyskretny
% s = s1+s2+s3+szum - sygnal poddawany analizie czestotliwosciowej
% sz - szum (zaklocenie)
% XA - widmo amplitudowe sygnalu s
% fs - czestotliwosc probkowania fs=1/krok_t
%
% zawartosc skryptu:
%

A0=1; A1=3; A2=2.2; % amplitudy
f0=30; f1=60; f2=35; % czestotliwosi
krok_t=0.01;  % krok w czasie - odstep probkowania w [s]
t=0:krok_t:3-krok_t;   % czas dyskretny
s0=A0*sin(2*pi*f0*t);
s1=A1*sin(2*pi*f1*t);
s2=A2*sin(2*pi*f2*t);
 sz=2*(rand(1,length(t)-0.5));  %szum
s=s0+s1+s2;  %suma sin
s=s0+s1+s2+sz+5;  % suma sin + szum

N=length(s)  % dlugosc szeregu czasowego s

% *********************
% liczenie FFT(s)
% *********************
X=fft(s);
XA=abs(X);   % widmo amplitudowe (modul X)

fs=1/krok_t    % czestotliwosc probkowania (Nuquista)
delta_f=fs/N   % rozdzielczosc widma (odstep miedzy probkami widma)
f=0:delta_f:fs-delta_f;  % wartosci czestotliwosci kolejnych prazkow widma

subplot(2,1,1)
clg
grid on
xlabel('Czas [s]')
ylabel('Sygnal')
title('Szereg probek w dziedzinie czasu')
plot(t,s)

subplot(2,1,2)
clg
grid on
xlabel('Czestotliwosc [Hz]')
ylabel('Widmo')
title('Widmo amplitudowe dziedzinie czestotliwosci')
stem(f,XA)


