% Skrypt rysuje modul funkcji transmitancji zmiennej zespolonej z dla
% zadanego polozenia zer i biegunow.

oneplot();
clf; clg;

% podaj polozenie zer i biegunow jako kolejne elementy wektorow wierszowych
bieg=[0.5+0.5i];
zera=[0.2+0.6i];

% dodaj zera i bieguny sprzezone
bieg=[bieg conj(bieg)];
zera=[zera conj(zera)];

% parametry wykresu
r = 1.25;
step = 0.05;
mxwart = 20;

[rz iz] = meshgrid([-r:step:r],[-r:step:r]*i);
z = rz+iz;
alfa = 0:0.1:2*pi;
o = exp(-i*alfa);

% wyznacz wspolczynniki wielomianow
bieg_p=poly(bieg);
zera_p=poly(zera);

H=polyval(zera_p,z)./polyval(bieg_p,z);
Ho=polyval(zera_p,o)./polyval(bieg_p,o);

mesh([-r:step:r],[-r:step:r],min(abs(H),mxwart));

hold on;
xlabel("Re z");
ylabel("Im z");
zlabel("|H(z)|");
legend("off");

plot3(real(o), imag(o), min(abs(Ho),mxwart),'b-');
plot3(real(zera), imag(zera), zeros(length(zera),1),'bo');
plot3(real(bieg), imag(bieg), zeros(length(bieg),1),'bx');
