function [y] = rect(n,T,fill)
%RECT generuje sygnal prostokatny o wartosciach -1, 1
% [y] = RECT(n,T,fill)
%
% Wejscie:
%	n - dlugosc sygnalu  w probkach
%	T - okres sygnalu w probkach
%	fill - wspolczynnik wypelnienia (domyslnie 0.5)
%
% Wyjscie
%	y - sygnal prostokatny

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

if (nargin<2)
	error("funkcja wymaga podania co najmniej dwoch parametrow");
elseif (nargin==2)
	fill = 0.5;
endif

n = round(n(1,1));
T = round(T(1,1));
fill = fill(1,1);

if (n<1)
	error("dlugosc sygnalu musi byc wieksza od 1");
endif
if (T<1)
	error("okres sygnalu musi byc wieksza od 1");
endif
if (fill<0)|(fill>1)
	error("wspolczynnik wypelnienia musi byc z przedzialu [0,1]");
endif

y = -ones(1,n);
t = find(mod((0:n-1),T)<=T*fill);
y(t) = -y(t);

endfunction
 