function prdens(x,n,pdf)
%PRDENS wykresla znormalizowany histogram ze zbioru obserwacji
%	PRDENS(x,n,pdf)
%
% Wykresla znormalizowany histogram ze zbioru
% obserwacji x, uzywajac n przedzialow
% opcjonalnie wykresla teoretyczna gestosc
% prawdopodobienstwa zadana funkcja pdf.
%
% Wejscie:
%	x	- zbior obserwacji
%	n	- ilosc przedzialow histogramu
%	pdf	- teoretyczna funkcja gestosci prawdopodobienstwa

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 

% oblicz znormalizowany histogram
[nn, xx]=hist(x,n,n/(max(x)-min(x)));

% wykresl histogram
xlabel("wartosc zmiennej losowej");
ylabel("gestosc prawdopodobienstwa");
bar(xx,nn);

% opcjonalnie wykresl teoretyczna gestosc prawdopodobienstwa
if (nargin>2)
	hold on;
	t=linspace(min(x),max(x),200);
	plot(t,feval(pdf,t),"-b;gestosc teoretyczna;");
	hold off;
endif

endfunction