function [times] = compar(N)
%DFTdef Oblicza DFT ,,z definicji''. Umozliwia obserwacje obliczania DFT ,,krok po kroku''

% parametry
%N = 8;			% dlugosc sygnalu w probkach
f = [1000, 2000];	% czestotliwosci sygnalow skladowych
ph = [0, (3/4)*pi];	% przesuniecia fazowe skladowych
A = [1, 0.5];		% amplitudy skladowych
bias = 0;		% wartosc skladowej stalej
fs = 8000;		% czestotliwosc probkowania
mnoznik = 5;		% zageszczenie probek dla reprezentacji ,,ciaglej''


n = 1:N;		% indeksy probek dla sygnalow bazowych
nContSize = mnoznik*N;	% indeksy dla reprezentacji ,,ciaglych''
% indeksy prbek
nSamp = 1:N;				% indeksy dla probek cyfrowych
nCont = linspace(1,N,nContSize);	% indeksy dla ,,ciaglych'' wersji sygnalow

% synteza sygnalu
freqLen = length(f);
x = zeros(1, 1:N);
xCont = zeros(1, 1:N*mnoznik);
for k=1:freqLen
	x = x + A(k)*sin(2*pi*f(k)*(nSamp-1)./fs + ph(k));
	xCont = xCont + A(k)*sin(2*pi*f(k)*(nCont-1)./fs + ph(k));
end

% dodanie skladowej stalej
x = x + bias;
xCont = xCont + bias;

tic() 
fx=fft(x,N);
fast = toc;
%printf("\tczas wykonania FFT funkcja fft = %f \n",fast);


tic() 
% inicjalizacja macierzy z wektorami przestrzeni bazowej
mSize = N;
B 	= zeros(mSize, N);
BCont 	= zeros(mSize, nContSize);

% ---------------- Obliczanie bazy
m = 1:N;
B(m,n) = exp(-i*2*pi*(m-1)'*(n-1)/N);

  for iM= 1:mSize
  	for iN = 1:nContSize
		BCont(iM,iN) = exp(-i*2*pi*(m(iM)-1)*(nCont(iN)-1)./N);
  	end
  end
 
%----------- Obliczanie DFT ---------------------

X = zeros(1,mSize);
for iM = 1:N
 X(iM) = x * (B(iM,:).');

end
disc = toc;
%printf("\tczas wykonania DFT z definicji = %f \n",disc);

%disp("obliczanie DFT zakonczone")
%disp("Nacisnij klawisz...")



oneplot();
clf;

subplot(2,2,1);clg;title("Modul DFT")
plot(n-1,abs(X),'b^'); hold "on";  grid "on"
plot(n-1,abs(X),'r5');
legend "off";replot

subplot(2,2,2);clg;title("kat DFT"); grid "on";
plot(n-1,angle(X),'b^'); hold "on";
%plot(n-1,real(X),'r5');
legend "off";replot

subplot(2,2,3);clg;title("Modul FFT");
plot(n-1,abs(fx),'^'); hold "on";  grid "on"
legend "off";replot

subplot(2,2,4);clg;title("kat FFT");
plot(n-1,angle(fx),'^'); hold "on";  grid "on"
legend "off";replot

printf("\tdft: ");
printf("%f\n",disc);
printf("\tfft: ");
printf("%f\n",fast);
times = [fast disc];

end