%DFTdef Oblicza DFT ,,z definicji''. Umozliwia obserwacje obliczania DFT ,,krok po kroku''

% parametry
N = 8;			% dlugosc sygnalu w probkach
f = [1000, 2000];	% czestotliwosci sygnalow skladowych
ph = [0, (3/4)*pi];	% przesuniecia fazowe skladowych
A = [1, 0.5];		% amplitudy skladowych
bias = 0;		% wartosc skladowej stalej
fs = 8000;		% czestotliwosc probkowanie
mnoznik = 5;		% zageszczenie probek dla reprezentacji ,,ciaglej''


% ktore elementy sktyptu maja byc wykonywane
WIZUALIZACJA_OBLICZANIA_DFT	= 1;
WIZUALIZACJA_WYNIKU 		= 1;


n = 1:N;	% indeksy probek dla sygnalow bazowych
% indeksy dla reprezentacji ,,ciaglych''
nContSize = mnoznik*N;	
% indeksy prbek
nSamp = 1:N;				% indeksy dla probek cyfrowych
nCont = linspace(1,N,nContSize);	% indeksy dla ,,ciaglych'' wersji sygnalow

% synteza sygnalu
freqLen = length(f);
x = zeros(1, 1:N);
xCont = zeros(1, 1:N*mnoznik);
for k=1:freqLen
	x = x + A(k)*sin(2*pi*f(k)*(nSamp-1)./fs + ph(k));
	xCont = xCont + A(k)*sin(2*pi*f(k)*(nCont-1)./fs + ph(k));
endfor

% dodanie skladowej stalej
x = x + bias;
xCont = xCont + bias;

% inicjalizacja macierzy z wektorami przestrzeni bazowej
mSize = N;
B 	= zeros(mSize, N);
BCont 	= zeros(mSize, nContSize);

% ---------------- Obliczanie bazy
m = 1:N;
B(m,n) = exp(-i*2*pi*(m-1)'*(n-1)/N);
 
  for iM= 1:mSize
  	for iN = 1:nContSize
		BCont(iM,iN) = exp(-i*2*pi*(m(iM)-1)*(nCont(iN)-1)./N);
  	endfor
  endfor;
  
%----------- Obliczanie DFT ---------------------
disp("Obliczam DFT")
X = zeros(1,mSize);
for iM = 1:N
 X(iM) = x * (B(iM,:).');
 if WIZUALIZACJA_OBLICZANIA_DFT
	% Re( x(n) )
	subplot(3,2,1); clg; title("Re(x)");
	hold "off"; plot(nCont,real(xCont),'r-'); hold "on";
	plot(n,real(x),'b5');
	legend "off";replot	
	
	% Im( x(n) )
	subplot(3,2,2); clg; title("Im(x)");
	hold "off", plot(nCont,imag(xCont),'r-'); hold "on";
	plot(n,imag(x),'b5');
	legend "off";replot	
	
	% f. bazowa Re
	subplot(3,2,3); clg;
	title(["funkcja bazowa dla m = ",num2str(iM-1),"(cz. rzeczywista)"]);
	hold "off"; plot(n,real(B(iM,:)),'b5'); hold "on";
	plot(nCont,real(BCont(iM,:)),'r-');
	legend "off";replot	
	
	% f. bazowa Im
	subplot(3,2,4); clg;
	title(["funkcja bazowa dla m = ",num2str(iM-1),"(cz. urojona)"]);
	hold "off"; plot(n,imag(B(iM,:)),'b5'); hold "on";
	plot(nCont,imag(BCont(iM,:)),'r-');
	legend "off";replot
		
	subplot(3,2,5); clg;	
	title("czesc rzeczywista widma");
	plot(n-1,real(X),'b^'); hold "on";
	plot(n-1,real(X),'r5');
	%axis([0 mSize-1 -1 1]);
	legend "off";replot
		
	subplot(3,2,6); clg;	
	title("czesc urojona widma");
	plot(n-1,imag(X),'b^'); hold "on";
	plot(n-1,imag(X),'r5');
	legend "off";replot
	
	disp(["\ndla m = ",num2str(iM-1),...
		"\nRe(X(",num2str(iM-1),")) = ",num2str(real(X(iM))),...
		"\nIm(X(",num2str(iM-1),")) = ",num2str(imag(X(iM))),...
		"\nNacisnij klawisz...\n"]);
	pause
 endif	
endfor

if WIZUALIZACJA_OBLICZANIA_DFT
	disp("obliczanie DFT zakonczone")
	disp("Nacisnij klawisz...")
	pause
endif

if WIZUALIZACJA_WYNIKU
	oneplot();clf;
	% modul
	subplot(2,2,1);clg;title("modul")
	plot(n-1,abs(X),'b^'); hold "on";  grid "on"
	plot(n-1,abs(X),'r5');		
	legend "off";replot
		
	% czesc rzeczywista
	subplot(2,2,2);clg;title("czesc rzeczywista"); grid "on";
	plot(n-1,real(X),'b^'); hold "on";
	plot(n-1,real(X),'r5');
	legend "off";replot
		
	% faza w stopniach
	subplot(2,2,3);clg;title("faza w stopniach");
	plot(n-1,360*angle(X)/(2*pi),'b^'); hold "on";  grid "on"
	plot(n-1,360*angle(X)/(2*pi),'r5');
	legend "off";replot
		
	% czesc urojona
	subplot(2,2,4);clg;title("czesc urojona");
	plot(n-1,imag(X),'b^'); hold "on";  grid "on"
	plot(n-1,imag(X),'r5');
	legend "off";replot
endif
