% HISTOGRAMY1 wykresla estymaty rozkladu prawdopodobienstwa i dystrybuanty I-szego rzedu procesu y=sin(2*pi*f*t+phi)
% gdzie phi to zmienna losowa o rozkladzie jednostajnym na przedziale [-pi,pi]

% Laboratorium - Podstawy i algorytmy przetwarzania sygnalow
% marzec 2005
% 


% generacja wielu obserwacji i wykreslanie histogramow
% w wybranych punktach dyskretnej osi czasu

N=5000;				% liczba obserwacji
f=100;				% czestotliwosc sinusoidy
t1=2; t2=7;			% wybrane punkty obserwacji
t=linspace(0,10/f*10,10);	% przedzial obserwacji

disp("generacja wielu obserwacji i wykreslanie histogramow\n...
w wybranych punktach dyskretnej osi czasu\n\n");

% generacja obserwacji
syg=zeros(N,length(t));
for k=1:N
	phi=rand(1)*2*pi-pi;		% losuj faze
	syg(k,:)=t+rand(1,length(t));	% generuj sygnal
end

% wizualizacja czterech realizacji procesu
for i = 1:4
	subplot(2,2,i); clg; grid "on";
	plot(syg(i,:),['-r;realizacja nr ',num2str(i),';']);
endfor
disp("nacisnij dowolny klawisz...\n\n");
kbhit();

% rysuj wykresy
subplot(2,2,1);
clg;
title("pierwszy punkt na osi czasu");
prdens(syg(:,t1),100,"sinpdf");

subplot(2,2,3);
clg;
title("drugi punkt na osi czasu");
prdens(syg(:,t2),100,"sinpdf");

subplot(2,2,2);
clg;
title("pierwszy punkt na osi czasu");
prdist(syg(:,t1),100,"sincdf");

subplot(2,2,4);
clg;
title("drugi punkt na osi czasu");
prdist(syg(:,t2),100,"sincdf");

disp("nacisnij dowolny klawisz...\n\n");
kbhit();



% wykreslanie histogramu na podstawie jednej obserwacji

N=5000;				% dlugosc obserwacji
f=100;				% czestotliwosc sinusoidy
t=linspace(0,10/f*N,N);		% przedzial obserwacji

disp("wykreslanie histogramu na podstawie jednej obserwacji");

% generacja obserwacji
syg=zeros(1,N);
phi=rand(1)*2*pi-pi;		% losuj faze
syg=sin(2*pi*f*t+phi);		% generuj sygnal

% rysuj wykresy
oneplot();
clg;
subplot(1,2,1);
title("histogram wykreslony\nna podstawie jednej obserwacji");
prdens(syg,100,"sinpdf");
subplot(1,2,2);
title("dystrybuanta empiryczna wykreslona\nna podstawie jednej obserwacji");
prdist(syg,100,"sincdf");
