function varargout = rmnk_gui(varargin)
% RMNK_GUI M-file for rmnk_gui.fig
%      RMNK_GUI, by itself, creates a new RMNK_GUI or raises the existing
%      singleton*.
%
%      H = RMNK_GUI returns the handle to a new RMNK_GUI or the handle to
%      the existing singleton*.
%
%      RMNK_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in RMNK_GUI.M with the given input arguments.
%
%      RMNK_GUI('Property','Value',...) creates a new RMNK_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before rmnk_gui_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to rmnk_gui_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help rmnk_gui

% Last Modified by GUIDE v2.5 10-Jan-2008 23:32:33

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rmnk_gui_OpeningFcn, ...
                   'gui_OutputFcn',  @rmnk_gui_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before rmnk_gui is made visible.
function rmnk_gui_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to rmnk_gui (see VARARGIN)

% Choose default command line output for rmnk_gui
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes rmnk_gui wait for user response (see UIRESUME)
% uiwait(handles.figure1);

global rozklady;
global rozkladz;
global rozkladx;
global dataptr;
dataptr = 1;
global colorptr;
colorptr = 0;

rozklady = {'Chisquare' 'Exponential' 'Geometric' 'Poisson' 'Rayleigh' 'T' 'Discrete Uniform' 'Beta' 'Binomial' 'Extreme Value' 'F' 'Gamma' 'Lognormal' 'Negative Binomial' 'Noncentral Chi-square' 'Normal' 'Uniform' 'Weibull' 'Hypergeometric' 'Noncentral F'};

rozklad_domyslny = 16; %norm - 16
set(handles.popupmenu1,'Value', rozklad_domyslny); 
set(handles.popupmenu2,'Value', rozklad_domyslny);
rozkladz = rozklady(rozklad_domyslny);
rozkladx = rozklady(rozklad_domyslny);

axes(handles.axes2)
title('usrednione bledy algorytmu');

axes(handles.axes5)
title('rozklad bledu');

axes(handles.axes3)
title('blad w poszczegolnych iteracjach algorymu');

set(handles.text2, 'String',  '[ wygeneruj przykład ]');
set(handles.popupmenu1,'String',rozklady);
set(handles.popupmenu2,'String',rozklady);

set(handles.edit1,'Visible','on' ,'String','0');
set(handles.edit4,'Visible','on' ,'String','0');

set(handles.edit2,'Visible','on','String','1');
set(handles.edit5,'Visible','on','String','0.1');

set(handles.edit3,'Visible','off','String','1');
set(handles.edit6,'Visible','off','String','0.1');


% --- Outputs from this function are returned to the command line.
function varargout = rmnk_gui_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    %fprintf('Generowanie przykładu\n');
    global a;
    a = random('Normal',0,1,str2double(get(handles.edit7, 'String')),1);
    a_str = [ '[' num2str(a') ']'];
    set(handles.text2, 'String',  a_str);


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1
%rozklady = {'Chisquare' 'Exponential' 'Geometric' 'Poisson' 'Rayleigh' 'T' 'Discrete Uniform' 'Beta' 'Binomial' 'Extreme Value' 'F' 'Gamma' 'Lognormal' 'Negative Binomial' 'Noncentral Chi-square' 'Normal' 'Uniform' 'Weibull' 'Hypergeometric' 'Noncentral F'};
global rozklady 
global rozkladx;
rozkladx = rozklady(get(handles.popupmenu1,'Value'));

if strmatch(rozkladx, {'Chisquare', 'Exponential', 'Geometric', 'Poisson', 'Rayleigh','T','Discrete Uniform'},'exact')
    set(handles.edit1,'Visible','on');
    set(handles.edit2,'Visible','off');
    set(handles.edit3,'Visible','off');    
elseif strmatch(rozkladx, {'Beta','Binomial','Extreme Value','F','Gamma','Lognormal','Negative Binomial','Noncentral Chi-square','Normal','Uniform','Weibull'},'exact')
    set(handles.edit1,'Visible','on');
    set(handles.edit2,'Visible','on');
    set(handles.edit3,'Visible','off');
elseif strmatch(rozkladx, {'Hypergeometric','Noncentral F'},'exact')
    set(handles.edit1,'Visible','on');
    set(handles.edit2,'Visible','on');
    set(handles.edit3,'Visible','on');
end


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double


% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double


% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2
global rozklady;
global rozkladz;
rozkladz = rozklady(get(handles.popupmenu2,'Value'));

if strmatch(rozkladz, {'Chisquare', 'Exponential', 'Geometric', 'Poisson', 'Rayleigh','T','Discrete Uniform'},'exact')
    set(handles.edit4,'Visible','on');
    set(handles.edit5,'Visible','off');
    set(handles.edit6,'Visible','off');    
elseif strmatch(rozkladz, {'Beta','Binomial','Extreme Value','F','Gamma','Lognormal','Negative Binomial','Noncentral Chi-square','Normal','Uniform','Weibull'},'exact')
    set(handles.edit4,'Visible','on');
    set(handles.edit5,'Visible','on');
    set(handles.edit6,'Visible','off');
elseif strmatch(rozkladz, {'Hypergeometric','Noncentral F'},'exact')
    set(handles.edit4,'Visible','on');
    set(handles.edit5,'Visible','on');
    set(handles.edit6,'Visible','on');
end


% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called
 
% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
 
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double


% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% wylicz macierz wejścia i wektor błędu
global a;
global rozkladx;
global rozkladz;
global dataptr;
global results_m;
global results_v;
global colorptr;
    
rozkladx = char(rozkladx);
rozkladz = char(rozkladz);

N = str2double(get(handles.edit8, 'String'));
S = str2double(get(handles.edit7, 'String'));


if strmatch(rozkladx, {'Chisquare', 'Exponential', 'Geometric', 'Poisson', 'Rayleigh','T','Discrete Uniform'},'exact')
    x = random(rozkladx,str2double(get(handles.edit1, 'String')),N,S);
elseif strmatch(rozkladx, {'Beta','Binomial','Extreme Value','F','Gamma','Lognormal','Negative Binomial','Noncentral Chi-square','Normal','Uniform','Weibull'},'exact')
    x = random(rozkladx,str2double(get(handles.edit1, 'String')),str2double(get(handles.edit2, 'String')),N,S);
elseif strmatch(rozkladx, {'Hypergeometric','Noncentral F'},'exact')
    x = random(rozkladx,str2double(get(handles.edit1, 'String')),str2double(get(handles.edit2, 'String')),str2double(get(handles.edit3, 'String')),N,S);
else
    error('nieznany rozkład prawdopodobienstwa!');
end

if strmatch(rozkladz, {'Chisquare', 'Exponential', 'Geometric', 'Poisson', 'Rayleigh','T','Discrete Uniform'},'exact')
    z = random(rozkladz,str2double(get(handles.edit4, 'String')),N,1);
elseif strmatch(rozkladz, {'Beta','Binomial','Extreme Value','F','Gamma','Lognormal','Negative Binomial','Noncentral Chi-square','Normal','Uniform','Weibull'},'exact')
    z = random(rozkladz,str2double(get(handles.edit4, 'String')),str2double(get(handles.edit5, 'String')),N,1);
elseif strmatch(rozkladz, {'Hypergeometric','Noncentral F'},'exact')
    z = random(rozkladz,str2double(get(handles.edit4, 'String')),str2double(get(handles.edit5, 'String')),str2double(get(handles.edit6, 'String')),N,1);
else
    error('nieznany rozkład prawdopodobienstwa!');
end

[an, an_tab] = rmnk(a, x, z, N, S);


colorspace = ['r' 'g' 'b' 'c' 'm' 'y' 'k'];

for i = 1:N
    plo(i) = sum(an_tab(i,:));
end

results_m(dataptr) = sum((a - an)./a * 100);
results_v(dataptr,:) = a-an;

axes(handles.axes2)
hold on;
plot(plo,colorspace(colorptr+1));
hold off;


axes(handles.axes3)
hold on;
plot(results_m,colorspace(1));          % wykresla bledy poszczegolnych iteracji
%stem(var(results_m),colorspace(2));
hold off;

axes(handles.axes3)
legend('blad [%]');

axes(handles.axes5)
c = mean(results_m);                     % sredni blad
sig = var(results_m);                  % wariancja bledu
q = 4;
x = linspace(c-q*sig,c+q*sig,100);

if (dataptr ~= 1)
    y = gaussmf(x, [sig c]);
    plot(x,y,colorspace(2));
    fprintf('\nwartosc srednia bledu : %f\n', c);
    fprintf('wariancja bledu : %f\n', sig);
end

title('rozklad bledu');

colorptr = mod(colorptr+1,size(colorspace,2));
dataptr = dataptr + 1;

function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit7 as text
%        str2double(get(hObject,'String')) returns contents of edit7 as a double


% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit8_Callback(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit8 as text
%        str2double(get(hObject,'String')) returns contents of edit8 as a double


% --- Executes during object creation, after setting all properties.
function edit8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global colorptr;
colorptr = 0;
global dataptr;
dataptr = 1;
global results_m;
results_m = [];
global results_v;
results_v = [];
cla(handles.axes2);
cla(handles.axes3);
%cla(handles.axes4);
cla(handles.axes5);


% --- Executes on button press in pushbutton6.
function pushbutton6_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
for k=1:10
    pushbutton4_Callback(hObject, eventdata, handles)
end

