//---------------------------------------------------------------------------

#pragma hdrstop

#include <iostream>
#include <fstream>
#include <math>

using namespace std;

//---------------------------------------------------------------------------

void lu_decomposition(int size, double **A, double **L, double **U)
{
  double sum = 0;

  for (int i = 0; i < size; i++)
  {
    L[i][i] = 1;
    for (int j = i; j < size; j++)
    {
      for (int k = 0; k < i; k++)
        sum += L[i][k] * U[k][j];
      U[i][j] = A[i][j] - sum;  sum = 0;
    }

    for (int j = (i + 1); j < size; j ++)
    {
      for (int k = 0; k < i; k++)
        sum = L[j][k] * U[k][i];
      L[j][i] = (1 / U[i][i]) * (A[j][i] - sum);  sum = 0;
    }
  }
}

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[])
{
  int size;
  ifstream input;
  ofstream output;
  input.open(argv[1]);          //wczytywanie danych z pliku
  input >> size;

  double **A = new double *[size];
  for (int i = 0; i < size; i++)
    A[i] = new double [size];

  double *X = new double [size];
  double *Y = new double [size];
  double *Z = new double [size];

  for (int i = 0; i < size; i++)
    {
    for (int j = 0; j < size; j ++)
      input >> A[i][j];
    input >> Y[i];
    }
  input.close();

  // w tym miejscu bedzie znajdowal sie modul eliminujacy mozliwosc dzielenia przez zero
  double temp;
  /*
    for (int i = 0; i < size; i++)
    {
     if (A[i][i] == 0)
     {
        for (int j = 0; j < size; j++)
        {
          temp = A[i][j];
          A[i][j] = A[i+1][j];
          A[i+1][j] = temp;
        }
      }
    }*/

  double **L = new double *[size];      //deklaracja macirzy L
  for (int i = 0; i < size; i++)
    L[i] = new double [size];

  double **U = new double *[size];      //deklaracja macirzy U
  for (int i = 0; i < size; i++)
    U[i] = new double [size];

  for (int i = 0; i < size; i++)        //zerowanie macierzy L i U
    for (int j = 0; j < size; j++)
      L[i][j] = U[i][j] = 0;

  lu_decomposition(size, A, L, U);              //dekompozycja wasciwa

  for (int i = 0; i < size; i++)                //obliczenie pierwszwego z rwna: L * Z = Y
  {
    temp = 0;
    for (int j = 0; j < (i + 1); j++)
      temp = temp + Z[j] * L[i][j];
    Z[i] = (Y[i] - temp) / L[i][i];
  }

  for (int i = (size - 1); i >= 0; i--)         //obliczenie drugiego z rwna: U * X = Z
  {
    temp = 0;
    for (int j = (size - 1); j > (i - 1); j--)
      temp = temp + X[j] * U[i][j];
    X[i] = (Z[i] - temp) / U[i][i];
  }

  output.open("lu_decomposition.out");
  for (int i = 0; i < size; i++)
    output << X[i] << endl;
  output.close();

        delete [] A;
        delete [] X;
        delete [] Y;
        delete [] Z;
        delete [] L;
        delete [] U;

        return 0;
}

//---------------------------------------------------------------------------
