//---------------------------------------------------------------------------

#include <iostream>
#include <fstream>
#include <math>

using namespace std;

//---------------------------------------------------------------------------

int gauss(int size, double **matrix, double *result)
{
  int max;
  double temp;
  for (int i = 0; i < size; i ++)       //doprowadzenie maciezy wspolczynnikow do postaci macierzy gornej trjkatnej
  {
    max = i;
    for(int j = i + 1; j < size; j++)
      if (fabs(matrix[j][i]) > fabs(matrix[max][i]))
        max = j;

    for (int k = i; k < size + 1; k++)
    {
      temp = matrix[i][k];
      matrix[i][k] = matrix[max][k];
      matrix[max][k]=temp;
    }

    if (matrix[i][i] == 0)
      return 0;         //uklad jest sprzeczny

    for (int l = i + 1; l < size; l++)
      for (int m = size; m >= i; m--)
        matrix[l][m] = matrix[l][m] - matrix[i][m] * matrix[l][i] / matrix[i][i];
  }

  for (int j = size - 1; j >= 0; j--)   //obliczenie rozwiazania
  {
    temp = 0;
    for (int k = j + 1; k <= size; k++)
      temp = temp + matrix[j][k] * result[k];
    result[j] = (matrix[j][size]-temp)/matrix[j][j];
  }
return 1;              //uklad ma rozwiazanie
};

#pragma argsused

//---------------------------------------------------------------------------

int main(int argc, char* argv[])
{
int size;

ifstream input;
ofstream output;

input.open(argv[1]);
input >> size;

double **matrix = new double *[size];
  for (int i = 0; i < size ; i++)
    matrix[i] = new double [size +1];

double *result = new double [size];

for (int i = 0; i < size; i++)
  for (int j = 0; j < size + 1; j++)
    input >> matrix[i][j];
input.close();

 if (!gauss(size, matrix, result))              //wyswietlenie informacji o rezultacie obliczen 
    {
    output.open("gauss_method.out");
    output << "Uklad jest sprzeczny" << endl;
    output.close();
    }
  else
    {
    output.open("gauss_method.out");
    for (int i = 0; i < size; i++)
      output << result[i] << endl;
    output.close();
    }
        delete [] matrix;
        delete [] result;
        return 0;
}
//---------------------------------------------------------------------------

