/***************************************************************************
 *   Copyright (C) 2007 by Mateusz   *
 *   mateusz@theozy   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "inc_muparser.h"
#include <iostream>

using namespace std;
using namespace mu;

class styczne{

	private:
	char *fn;
	Parser p;
	int iteracja;
	
	int w_stopu(double ws, double skok);
	double f(double zm);
	double fp(double zm, double dp);
	
	public:
	styczne(char* funkcja, Parser prs);
	double metoda_stycznych(double war_stopu, double pkt_pocz, double dokl_pochodnej);
};

int main(int argc, char *argv[])
{

	
	if (argc < 4) {
		cout << "\nZbyt maa liczba parametrw!";
		cout << "\nSposb uycia: ./styczne funkcja warunek_stopu punkt_pocztkowy [dokado_pochodnej]"<< endl;
		return -2;
	}
	else {
		Parser pr;
		styczne ms (argv[1],pr);
		double v2,v3,v4;
			v2 = atof(argv[2]);
			v3 = atof(argv[3]);
			v4 = 0.01;

		if (argc >4) {
			v4 = atof(argv[4]);
		};
        fstream temp;
		cout << ms.metoda_stycznych(v2,v3,v4) <<endl;
		return 0;
	};

}

styczne::styczne(char *funkcja, Parser prs){

	p=prs;
	fn=funkcja;
	iteracja=0;
};

double styczne::f(double zm){
	try{
		p.DefineVar("x", &zm);
		p.SetExpr(fn);
		return p.Eval();
	}
	catch (Parser::exception_type &e){
		std::cout << e.GetMsg() << endl;
	}

};

double styczne::fp(double zm, double dp){

	return ( (f(zm+dp) -f(zm-dp))/(2*dp) );
};

double styczne::metoda_stycznych(double war_stopu, double pkt_pocz, double dokl_pochodnej){
	double xi, xi_1, x_rozn;
	xi_1 = pkt_pocz;
	do{
		xi = xi_1 - f(xi_1)/fp(xi_1,dokl_pochodnej);
		iteracja++;
		x_rozn = fabs(xi - xi_1);
		xi_1 = xi;
	}while(w_stopu(war_stopu, x_rozn));
	//cout << iteracja << endl;
	return xi;
};

int styczne::w_stopu(double ws, double skok){

	if (ws >= 1){
		if (iteracja >= ws) return 0;
	}
	else{
		if (skok < ws) return 0;
	};
	return 1;
};

