/***************************************************************************
 *   Copyright (C) 2007 by Luke   *
 *   luke@ubuntu   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include <stdio.h>
#include <math.h>
#include <iostream>
#include <iomanip>
//#include <cstdlib>
#include <string>
#include "inc_muparser.h"

using namespace std;

class Sieczne
{
	public:
	 string wyr;
	 double metoda_siecznych(double x1, double x2, double e, int n);
	 double f(double x);
};

double Sieczne::metoda_siecznych(double x1, double x2, double e, int n)
{
    double d;
    for (int i = 0; i<n; i++)
    {
		d=( (x2-x1) / ( f(x2)-f(x1) ) )*f(x2);
		if (fabs(d) < e) return x2;
		x1=x2; 
		x2-=d;
    }
    return x2;
}

double Sieczne::f(double x)
{
	using namespace mu;

	Parser p;
	try
	{	
    	p.DefineVar("x", &x);	
    	p.SetExpr(wyr);
	}
	catch (Parser::exception_type &e)
	{
	    std::cout << e.GetMsg() << std::endl;
	}
	return p.Eval();
}

int main(int argc, char *argv[])
{
	if (argc > 1)
	{
		Sieczne s;
		s.wyr=argv[1];

		double blad=0,b=0,e=0; int iter=0;
		if (argc >= 3) b=atof(argv[2]); else b=0.9*s.f(0);
		if (argc >= 4) e=atof(argv[3]); else e=1.1*s.f(0);
		if (argc >= 5) blad=atof(argv[4]); else blad=1E-10;
		if (argc >= 6) iter=atoi(argv[5]); else iter=100;

		cout << setprecision(15) << s.metoda_siecznych(b,e,blad,iter) << endl;
	}
	else cout<<endl<<"usage: sieczne wyrazenie [pierwszy punkt do obliczen] [drugi punkt do obliczen] [epsilon] [liczba iteracji]"<<endl<<"parametry musza byc podawane w kolejnosci"<<endl<<"wyrazenie ze zmienna \"x\""<<endl;

  return EXIT_SUCCESS;
}
