/***************************************************************************
 *   Copyright (C) 2007 by stanley,,,                                      *
 *   stanley@xdsl-6036                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*Metoda  sie sypie gdy:
- funkcja nie przecina na zadanym przedziale osi x,
- funkcja jest styczna do osi x,
- funkcja w zadanym przedziale przecina os x wiecej niz raz.
Nie sa to wady implementacji tylko metody!!!!!
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cstdlib>
#include <math.h>
#include <string.h>
#include <fstream>
#include "muParser.h"
#include "muParser.cpp"
#include "muParserBase.cpp"
#include "muParserBytecode.cpp"
#include "muParserCallback.cpp"
#include "muParserError.cpp"
#include "muParserTokenReader.cpp"

using namespace std;
using namespace mu;

Parser p;

//---------------------------------------------------------------------------

double f(double value)
{
  p.DefineVar("x", &value);
  return p.Eval();
}

//---------------------------------------------------------------------------

int main(int argc, char* argv[])
{
  p.SetExpr(argv[1]);
  double eps = 0.000001;
  double lower_bound = atof(argv[2]);
  double upper_bound = atof(argv[3]);
  double result;
  ofstream output;

  if((f(lower_bound) * f(upper_bound)) == 0)    //jezeli funkcja sie zeruje w jadnej z granic przedzialu
  {
    if (f(lower_bound) == 0)    //jezeli funkcja sie zeruje w lewej granicy przedzialu
    {
      output.open("bisection.out");
      output << lower_bound << endl;
      output.close();
    }
    else if (f(upper_bound) == 0)    //jezeli funkcja sie zeruje w prawej granicy przedzialu
    {
      output.open("bisection.out");
      output << upper_bound << endl;
      output.close();
    }
  }

  else if((f(lower_bound) * f(upper_bound)) < 0)        //jezeli funkcja zeruje sie wewnatrz przedzialu
  {
    result = lower_bound;
    while ((upper_bound - lower_bound ) > eps)
    {
      result = (upper_bound + lower_bound ) / 2;
      if ((f(lower_bound) * f(result)) <= 0)
        upper_bound = result;
      else if ((f(result) * f(upper_bound)) <= 0)
        lower_bound = result;
      else break;
    }
  output.open("bisection.out");
  output << result << endl;
  output.close();
  }
  else
  {
  output.open("bisection.out");
  output << "Wprowadzona funkcja nie zreuje sie na zadanym przedziale\nlub metoda nie zdolala znalezc miejsca zerowego" << endl;
  output.close();
  }

//---------------------------------------------------------------------------

  return 0;
}
 
