class CHeap {
 public:
 int *H,n;
 void init(int H[]) { this->H=H; n=0;}
 void clear() { n=0;}
 virtual int comp(int x,int y)  { return (H[x]<H[y]);};
 virtual void swap(int i,int o) { int tmp=H[i]; H[i]=H[o]; H[o]=tmp;};
 void up(int ps);
 void down(int ps);
 void add(int el) { H[++n]=el; up(n);}
 int delroot() {int  el=H[1]; swap(1,n); n--; down(1); return el;}
 int empty() { return (n==0);}
};

void CHeap::up(int ps)
{  int i=ps, o;
   while (i>1)
   { o=i/2;
     if  (comp(i,o)) { swap(i,o); i=o;} else i=0;
   }
}

void CHeap::down(int ps)
{  int i=ps, ns;
   while (2*i<=n)
   { ns=2*i;
     if (ns+1<=n) if (comp(ns+1,ns)) ns++;
     if  (comp(ns,i)) { swap(i,ns); i=ns;} else i=n+1;
   }
}

class CHeapInx : public CHeap {
 public:
 int *T;
 void init(int H[], int T[]) { this->T=T; CHeap::init(H); }
 virtual int comp(int x,int y)  { return (T[H[x]]<T[H[y]]);};
};

class CHeapInxDyn : public CHeapInx {
 public:
 int *PS;
 void init(int H[], int T[], int PS[]) { this->PS=PS; CHeapInx::init(H,T);}
 void add(int el) { PS[el]=n+1; CHeapInx::add(el);}
 virtual void mod(int x,int w)  { T[x]=w; up(PS[x]); };
 virtual void swap(int i,int o) {  int t1=H[i], t2=H[o];
                                       PS[t1]=o; PS[t2]=i;
                                   CHeapInx::swap(i,o);
                                  };
};


 